/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.message;

import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.HandshakeMessage;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.minecraft.network.FriendlyByteBuf;

public class MessageSyncBackpacks
extends HandshakeMessage<MessageSyncBackpacks> {
    private List<Backpack> backpacks;

    public MessageSyncBackpacks() {
    }

    public MessageSyncBackpacks(List<Backpack> backpacks) {
        this.backpacks = backpacks;
    }

    public void encode(MessageSyncBackpacks message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.backpacks.size());
        message.backpacks.forEach(backpack -> backpack.write(buffer));
    }

    public MessageSyncBackpacks decode(FriendlyByteBuf buffer) {
        ArrayList<Backpack> backpacks = new ArrayList<Backpack>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            backpacks.add(new Backpack(buffer));
        }
        return new MessageSyncBackpacks(backpacks);
    }

    public void handle(MessageSyncBackpacks message, MessageContext context) {
        CountDownLatch latch = new CountDownLatch(1);
        context.execute(() -> {
            BackpackManager.instance().updateClientBackpacks(message.backpacks);
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Constants.LOG.error("Failed to update backpacks", (Throwable)e);
        }
        context.setHandled(true);
        context.reply((IMessage)new HandshakeMessage.Acknowledge());
    }
}

